let cart = [];

function addToCart(item, price) {
  cart.push({ item, price });
  alert(item + " added to cart!");
}

// Display cart on order.html
function displayCart() {
  const cartItemsDiv = document.getElementById("cart-items");
  const cartTotalSpan = document.getElementById("cart-total");

  if (!cartItemsDiv) return; // only run on order.html

  cartItemsDiv.innerHTML = "";
  let total = 0;

  cart.forEach((c, index) => {
    total += c.price;
    cartItemsDiv.innerHTML += `
      <p>${c.item} - ₦${c.price} 
      <button onclick="removeFromCart(${index})">Remove</button></p>
    `;
  });

  cartTotalSpan.textContent = total;
}

function removeFromCart(index) {
  cart.splice(index, 1);
  displayCart();
}

// WhatsApp checkout
document.addEventListener("DOMContentLoaded", () => {
  const orderForm = document.getElementById("orderForm");
  if (orderForm) {
    orderForm.addEventListener("submit", (e) => {
      e.preventDefault();
      const name = document.getElementById("customerName").value;
      const phone = document.getElementById("customerPhone").value;
      const address = document.getElementById("customerAddress").value;

      let orderText = `Hello, I am ${name}. My order:\n`;
      cart.forEach(c => {
        orderText += `- ${c.item}: ₦${c.price}\n`;
      });
      orderText += `\nTotal: ₦${cart.reduce((sum, c) => sum + c.price, 0)}\n`;
      orderText += `Delivery Address: ${address}\nPhone: ${phone}`;

      const whatsappURL = `https://wa.me/2348123456789?text=${encodeURIComponent(orderText)}`;
      window.open(whatsappURL, "_blank");
    });
  }

  displayCart();
});